#!/bin/bash
#SBATCH --gpus=2
module load  anaconda/2022.10
source  activate vlt5

# The name of experiment
name=VLT5-16

output=snap/Multi30K/$name
mkdir -p $output

PYTHONPATH=$PYTHONPATH:./src \
python -m torch.distributed.launch \
    --nproc_per_node=2 \
   /HOME/scz5690/run/VL-T5-main/VL-T5/src/mmt.py \
        --distributed --multiGPU \
        --train train \
        --valid val \
        --test test_2016_flickr,test_2017_flickr,test_2018_flickr \
        --optim adamw \
        --warmup_ratio 0.1 \
        --clip_grad_norm 5 \
        --lr 5e-5 \
        --epochs 40 \
        --num_workers 4 \
        --backbone 't5-base' \
        --output $output \
        --num_beams 5 \
        --batch_size 30 \
        --max_text_length 40 \
        --gen_max_length 40 \
        --do_lower_case | tee -a $output/train.log \
